/** @file   civiliancontroller.cpp
 * @brief   Implementation of CivilianController - class.
 * @version $Revision: 1.1.1.1 $
 * @author  Tomi Lamminsaari
 */

#include "civiliancontroller.h" // class's header file

namespace WeWantWar {

// class constructor
CivilianController::CivilianController( GameObject* pObj ) :
  WaypointController( pObj )
{
	// insert your code here
}

// class destructor
CivilianController::~CivilianController()
{
	// insert your code here
}


void CivilianController::update()
{
  m_counter -= 1;
  if ( m_counter >= 0 ) {
    return;
  }
  
  if ( this->validRoute() == false ) {
    // We're not having a valid route, so we exit.
    this->reset();
    m_counter = 20;
    return;
  }

  // Check if we've reached our current waypoint.
  if ( this->waypointReached() == true ) {
    // Yes we have. Now we start heading towards the next waypoint.
    this->step();
  }
  
  // If our nose points towards the waypoint, we move
  this->reset();
  if ( this->isFacingWaypoint( 20 ) == true ) {
    m_forward = 2;
    m_counter = 4;

  } else {
    // We're not facing the waypoint. We keep on turning.
    m_turn = this->findShortestTurn();
    m_forward = 1;
    m_counter = 3;
  }
}

} // end of namespace

/**
 * Version history
 * ===============
 * $Log: civiliancontroller.cpp,v $
 * Revision 1.1.1.1  2006/01/21 23:02:43  lamminsa
 * no message
 *
 * Revision 1.0  2005-11-06 01:15:34+02  lamminsa
 * Initial revision
 *
 */
